# log-aop
### 吴远韬 PB20061233
-----
## 1.AOP
aop面向切面编程，是编程中一个很重要的思想。利用AOP可以对我们边缘业务进行隔离，降低无关业务逻辑耦合性。提高程序的可重用性，同时提高了开发的效率。一般用于`日志记录，性能统计，安全控制，权限管理，事务处理，异常处理，资源池管理`使用场景

注解	说明
+ @Aspect	将一个 java 类定义为切面类
+ @Pointcut	定义一个切入点，可以是一个规则表达式，比如下例中某个 package 下的所有函数，也可以是一个注解等
+ @Before	在切入点开始处切入内容
+ @After	在切入点结尾处切入内容
+ @AfterReturning	在切入点 return 内容之后处理逻辑
+ @Around	在切入点前后切入内容，并自己控制何时执行切入点自身的内容
+ @AfterThrowing	用来处理当切入内容部分抛出异常之后的处理逻辑
+ @Order(100)	AOP 切面执行顺序， @Before 数值越小越先执行，@After 和 @AfterReturning 数值越大越先执行

## 2.AopLog
```java
public class AopLog {
    @Pointcut("execution(public * com.xkcoding.log.aop.controller.*Controller.*(..))")
}
```
该Pointcut注解定义了在执行xxxController任意方法时触发

```java
@Around("log()")
    public Object aroundLog(ProceedingJoinPoint point) throws Throwable
```
该方法实现了在执行test或testJson方法时，执行自定义的Log操作，操作在该方法实现中，打印自定义的log类对象的信息，包括ip，浏览器型号等

log类如下
```java
static class Log {
        // 线程id
        private String threadId;
        // 线程名称
        private String threadName;
        // ip
        private String ip;
        // url
        private String url;
        // http方法 GET POST PUT DELETE PATCH
        private String httpMethod;
        // 类方法
        private String classMethod;
        // 请求参数
        private Object requestParams;
        // 返回参数
        private Object result;
        // 接口耗时
        private Long timeCost;
        // 操作系统
        private String os;
        // 浏览器
        private String browser;
        // user-agent
        private String userAgent;
    }
```

## 3.Controller
```java
public class TestController {

    /**
     * 测试方法
     *
     * @param who 测试参数
     * @return {@link Dict}
     */
    @GetMapping("/test")
    public Dict test(String who) {
        return Dict.create().set("who", StrUtil.isBlank(who) ? "me" : who);
    }

    /**
     *  测试post json方法
     * @param map 请求的json参数
     * @return {@link Dict}
     */
    @PostMapping("/testJson")
    public Dict testJson(@RequestBody Map<String, Object> map) {

        final String jsonStr = JSONUtil.toJsonStr(map);
        log.info(jsonStr);
        return Dict.create().set("json", map);
    }
}
```

## 4.测试
### 测试get请求
浏览器访问
```
http://127.0.0.1:8080/demo/test
```
![](img/logaop/1.png)

打印日志如下
![](img/logaop/2.png)

### 测试Post请求
使用Postman软件，发送Post请求，Body为json格式
![](img/logaop/3.png)
打印日志如下
![](img/logaop/4.png)
