# helloworld
### 吴远韬 PB20061233
-----
## 代码分析
首先看helloworld类
```java
public class SpringBootDemoHelloworldApplication {

    public static void main(String[] args) {
        SpringApplication.run(SpringBootDemoHelloworldApplication.class, args);
    }

    /**
     * Hello，World
     *
     * @param who 参数，非必须
     * @return Hello, ${who}
     */
    @GetMapping("/hello")
    public String sayHello(@RequestParam(required = false, name = "who") String who) {
        if (StrUtil.isBlank(who)) {
            who = "World";
        }
        return StrUtil.format("Hello, {}!", who);
    }
}
```

### @GetMapping()
@GetMapping(/hello)将url带/hello的get请求映射到sayHello上
### @RequestParam()
我们已经通过定义@GetMappingMapping来处理URL请求了，我们也需要再处理URL的函数中获取URL中的参数-也就是?key=value1&key2=value2这样的参数列表。通过注解@RequestParam可以轻松的将URL中的参数绑定到处理函数方法的变量中

## 测试
浏览器访问
```
http://127.0.0.1:8080/demo/hello?who=xxx
```
sayHello中的参数who就是xxx，返回Hello，xxx！

![](img/helloworld/1.png)